varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform float		scale;
uniform vec2		time;
uniform vec2 		screenres;
vec4 				color;

vec3 ssDither(vec2 screenpos)
{
	/*vec3 vDither = vec3(dot(vec2(171.0,231.0), screenpos.xy + time));
	vDither = fract(vDither/vec3(103.0,71.0,97.0));
	return vDither;*/
	float x = (screenpos.x + 4.0 ) * (screenpos.y + 4.0 ) * (time.x * 10.0);
	return vec3(mod((mod(x, 13.0) + 1.0) * (mod(x, 123.0) + 1.0), 0.01)-0.005) * scale;
}

// VHS TEST
vec3 tex2D( sampler2D _tex, vec2 _p ){
  vec3 col = texture( _tex, _p ).xyz;
  if ( 0.5 < abs( _p.x - 0.5 ) ) {
    col = vec3( 0.1 );
  }
  return col;
}

float hash( vec2 _v ){
  return fract( sin( dot( _v, vec2( 89.44, 19.36 ) ) ) * 22189.22 );
}

float iHash( vec2 _v, vec2 _r ){
  float h00 = hash( vec2( floor( _v * _r + vec2( 0.0, 0.0 ) ) / _r ) );
  float h10 = hash( vec2( floor( _v * _r + vec2( 1.0, 0.0 ) ) / _r ) );
  float h01 = hash( vec2( floor( _v * _r + vec2( 0.0, 1.0 ) ) / _r ) );
  float h11 = hash( vec2( floor( _v * _r + vec2( 1.0, 1.0 ) ) / _r ) );
  vec2 ip = vec2( smoothstep( vec2( 0.0, 0.0 ), vec2( 1.0, 1.0 ), mod( _v*_r, 1. ) ) );
  return ( h00 * ( 1. - ip.x ) + h10 * ip.x ) * ( 1. - ip.y ) + ( h01 * ( 1. - ip.x ) + h11 * ip.x ) * ip.y;
}

float noise( vec2 _v ){
  float sum = 0.;
  for( int i=1; i<9; i++ )
  {
    sum += iHash( _v + vec2( i ), vec2( 2. * pow( 2., float( i ) ) ) ) / pow( 2., float( i ) );
  }
  return sum;
}

void main()
{
	// VHS TEST
	color=texture2D(tex,texcoord);
	
	// bloom
	/*for( float x = -4.0; x < 0.5; x += 0.5 ){
		color.xyz += vec3(
		  tex2D( tex, texcoord + vec2( x - 0.0, 0.0 ) * 7E-3 ).x,
		  tex2D( tex, texcoord + vec2( x - 2.0, 0.0 ) * 7E-3 ).y,
		  tex2D( tex, texcoord + vec2( x - 4.0, 0.0 ) * 7E-3 ).z
		) * 0.1;
	  }
	color *= 0.5;

	// ac beat
	//color *= 1.0 + clamp( noise( vec2( 0.0, texcoord.y + time * 0.2 ) ) * 0.6 - 0.25, 0.0, 0.1 );
*/
	
	//color=texture2D(tex,texcoord);
	vec3 grain=1.0 - ssDither(texcoord);
	gl_FragColor.rgb = color.rgb*grain;//mix(color.rgb,color.rgb*,scale);
}
